/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageSplitterPart
implements IMessage {
    private short id;
    private byte messageClassId = (byte)-1;
    private byte[] payload;

    public MessageSplitterPart() {
    }

    public MessageSplitterPart(short id, byte[] payload) {
        if (payload.length > 32760) {
            throw new IllegalArgumentException("Invalid payload");
        }
        this.id = id;
        this.payload = payload;
    }

    public MessageSplitterPart(short id, byte messageClassId, byte[] payload) {
        this(id, payload);
        this.messageClassId = messageClassId;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readShort();
        this.messageClassId = buf.readByte();
        this.payload = new byte[buf.readShort()];
        buf.readBytes(this.payload);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)this.id);
        buf.writeByte((int)this.messageClassId);
        buf.writeShort(this.payload.length);
        buf.writeBytes(this.payload);
    }

    public short getId() {
        return this.id;
    }

    public byte getMessageClassId() {
        if (!this.isLast()) {
            throw new UnsupportedOperationException("Not the last part");
        }
        return this.messageClassId;
    }

    public boolean isLast() {
        return this.messageClassId != -1;
    }

    public byte[] getPayload() {
        return this.payload;
    }
}

